local tonumber = tonumber
local negativeInfinity, positiveInfinity = -math.huge, math.huge
local torealnumber = function(value) return (negativeInfinity < value and value < positiveInfinity) and value end

LinearScaler = function(min, max, rectMin, rectSize)
    -- rectMin + rectSize * (value - min) / (max - min)
    local A = rectMin - rectSize * min / (max - min)
    local M = rectSize / (max - min)
    return function(value, size)
        value = tonumber(value)
        if value then
            if size then
                size = tonumber(size)
                if size then
                    return torealnumber(A + M * (value - size / 2)), torealnumber(A + M * (value + size / 2))
                end
            else
                return torealnumber(A + M * value)
            end
        end
    end
end

return LinearScaler
